// ABC_cookie_helpers. js - v1.2 released 11/10/2005 by Ira Baron
// Cookie management functions
// AllergyBuyersClub.com - all rights reserved

// ===============================================
// Functions to manage the creation and consumption of cookies.  Also tests whether cookies are
// enabled in the users' browser
// ===============================================

// Are cookies turned on?
function abc_testABCCookiesAreOn()
	{
	// Try to create a cookie and read its value back
	var testValue = "AOK";
	var testName = "ABCTestCookie";

	abc_createABCCookie(testName , testValue , .001);

	if(testValue == abc_readABCCookie(testName ))
		{
		return true;
		}
	else
		{
		return false;
		}
	}
	
// Create a cookie
function abc_createABCCookie(name, value, days)
	{
	if (days)
		{
		var date = new Date();
		date.setTime(date.getTime()+(days*24*60*60*1000));
		var expires = "; expires="+date.toGMTString();
		}
	else var expires = "";
	document.cookie = name+"="+value+expires+"; path=/";
	}

// Read the value of a cookie
function abc_readABCCookie(name)
	{
	var nameEQ = name + "=";
	var ca = document.cookie.split(';');
	for(var i=0;i < ca.length;i++)
		{
		var c = ca[i];
		while (c.charAt(0)==' ') c = c.substring(1,c.length);
		if (c.indexOf(nameEQ) == 0) 
			{
			return c.substring(nameEQ.length,c.length);
			}
		}
	return null;
	}

// Erase a cookie
function abc_eraseABCCookie(name)
	{
	abc_createABCCookie(name,"",-1);
	}

