// ************************************COPYRIGHT BostonGreenGoods.com - All rights reserved. ****************************************************
// ************************************************************************************************************************************************************
// Globals - TOP
// ************************************************************************************************************************************************************
// Screen padding from edges
var offsetPad = 20;

// Mouse position globals
var mouseX = 0;
var mouseY = 0; 

// Popup image open flag
var popUpUp = false;

// Image and containing Div
var popupImage = null;
var popupDiv = null;

// Floating SKU popup
var hoverPopupDiv = null;
var currentPopupElemId = "";
var checkForRemoval = null;
var removalPad = 2;
var launchMouseX = 0;
var launchMouseY = 0;
var  floatLeftOffset = 100;
//var  floatSKUWidth = 700;
var verticalOffset = 15;
var allowHoverPopupClose = true;
//var dropListActive = false;
var mouseHasExited = false;
var mouseFirstEntry = false;

// Any currently open popup image
var currentPopup = null;

var IE = document.all?true:false

// If NS -- that is, !IE -- then set up for mouse capture
if (!IE) document.captureEvents(Event.MOUSEMOVE)

// Set-up to use getMouseXY function onMouseMove
//document.onmousemove = locateMouse;
enableMouseTracking();


// ************************************************************************************************************************************************************
var navHoverTimeout = null;
var navHoverDelay = 2500;
var navHoverDelayExit = 250;

// ************************************************************************************************************************************************************
function startHoverTimeout(delayTime)
{
	if(typeof navHoverTimeout != "undefined")
		endHoverTimeout();

	if(allowHoverPopupClose == true)
		navHoverTimeout = setTimeout("removeHoverPopup()",delayTime);
}

// ************************************************************************************************************************************************************
function endHoverTimeout()
{
	clearTimeout(navHoverTimeout);
	navHoverTimeout = null;
}

// ************************************************************************************************************************************************************
function enableMouseTracking() {
	document.onmousemove = locateMouse;
}

// CSS class, floatLeftOffset, verticalOffset 
// ************************************************************************************************************************************************************
function floatNav(navID) {

	floatLeftOffset = 80;
	verticalOffset = -20;

	floatElement(navID, "popupNavDiv", "popupNavTable", 540);
}

// ************************************************************************************************************************************************************
function floatSKU(skuID) {

	floatLeftOffset = 110;
	verticalOffset = 10;

	floatElement(skuID, "popupSKUDiv", "popupSKUTable", 650);
}

// ************************************************************************************************************************************************************
function floatElement(elementID, floatDivClass, floatTableClass, floatHoverWidth) 
{

	if(currentPopupElemId != elementID)
	{
		removeHoverPopup();
		currentPopupElemId = elementID;
	}

	if(hoverPopupDiv == null)
	{
		allowHoverPopupClose = true;
		mouseHasExited = false;
		mouseFirstEntry = false;
	
		var elementLocation = document.getElementById(elementID);
	
		if(elementLocation != null)
		{
			launchMouseX = mouseX;
			launchMouseY = mouseY;

			hoverPopupDiv=document.createElement("div");
			hoverPopupDiv.className = floatDivClass;

			var scrollPosX = findScrollLeft();
			var scrollPosY = findScrollTop();
			hoverPopupDiv.style.top = (launchMouseY + verticalOffset + (window.getComputedStyle ? 0: scrollPosY)) + "px";
			hoverPopupDiv.style.left = floatLeftOffset + "px"; //(mouseX + (window.getComputedStyle ? 0: scrollPosX) - (offsetPad * 7)) + "px"; //window.getComputedStyle
			hoverPopupDiv.style.width = floatHoverWidth + "px";
	
			var nodeClone = elementLocation.cloneNode(true);

			var newTable = document.createElement("table");
			newTable.className =  floatTableClass;
			newTable.id = "sizeThis";

			var newTBody = document.createElement("tbody");
			var newTR = document.createElement("tr");
			var newTD = document.createElement("td");

			newTD.appendChild(nodeClone);
			newTR.appendChild(newTD);
			newTBody.appendChild(newTR);

			newTBody.appendChild(newTR);
			newTable.appendChild(newTBody);
			hoverPopupDiv.appendChild(newTable);

			var body = document.getElementsByTagName("body");
			body[0].appendChild(hoverPopupDiv);
			newTable.focus();

			if(!((mouseX >= (floatLeftOffset))
			  && (mouseX <= (floatLeftOffset  + hoverPopupDiv.offsetWidth)) 
			  && (mouseY >= (launchMouseY + verticalOffset)) 
			  && (mouseY <= (launchMouseY + hoverPopupDiv.offsetHeight))))
			{
				startHoverTimeout(navHoverDelay);
			}
			else
			{
				mouseHasExited = false;
				mouseFirstEntry = true;
			}
		}
	}
}

// ************************************************************************************************************************************************************
function removeHoverPopup() {

//alert("Killing Hover Popup with closeSKUPopup="+closeSKUPopup);

if(hoverPopupDiv != null) 
	{
	endHoverTimeout();
	var body = document.getElementsByTagName("body");
	body[0].removeChild(hoverPopupDiv);
	hoverPopupDiv = null;
	}
}

// ************************************************************************************************************************************************************
function popUp(URL) {

if(URL.indexOf(".html") > 0)  // Don't try to load and pop html pages like images.
	{
	popUpPrior(URL);
	}
else
	{
	popUpWithArgs(URL, null, null) ;
	}
}

// ************************************************************************************************************************************************************
function popUpWithArgs(URL, width, height) 
{
document.body.style.cursor = 'wait';

popupImage = document.createElement("img");
popupImage.onload = prepPopFrameless;
popupImage.src = URL;
}

// ************************************************************************************************************************************************************
function listActivated() {
	allowHoverPopupClose = false;
	mouseFirstEntry = false;
}

// ************************************************************************************************************************************************************
function listDeactivated() {
	allowHoverPopupClose = true;
}

// ************************************************************************************************************************************************************
// Pop up a frameless version of the image selected by the user
// ************************************************************************************************************************************************************
function popFrameless(img, width, height) {

document.body.style.cursor = 'wait';

popupImage = document.createElement("img");
popupImage.onload = prepPopFrameless;
popupImage.src = img;
}

// ************************************************************************************************************************************************************
function prepPopFrameless(event)
{
var windowWidth =  findClientWidth();
var windowHeight =  findClientHeight();
var scrollPosX = findScrollLeft();
var scrollPosY = findScrollTop();
mouseX = (((windowWidth - popupImage.width) / 2) + offsetPad + (window.getComputedStyle ? scrollPosX : 0));
mouseY = (((windowHeight - popupImage.height) / 2) + offsetPad + (window.getComputedStyle ? scrollPosY : 0));

reallyPopFrameless(popupImage.width, popupImage.height);
}

// ************************************************************************************************************************************************************
// Pop up a frameless version of the image selected by the user
// ************************************************************************************************************************************************************
function reallyPopFrameless(width, height) {

if(currentPopup)
	{
	closePopFrameless(currentPopup)
	}

// Create the new div to float the image (use global for exansion function)
popupDiv=document.createElement("div");
popupDiv.className = "popupDiv";

// Set maxes for div expansion
var maxWidth =  width;
var maxHeight = height;

// Create the new image object and add it to its parent (use global for exansion function)
popupImage.style.width = maxWidth + "px";
popupImage.style.height = maxHeight + "px";
popupImage.onclick = new Function ('closePopFrameless(this)');
popupDiv.appendChild(popupImage);

// Create the new close label and add it to its parent
var popupCloseLabel = document.createElement("div");
popupCloseLabel.onclick = new Function ('closePopFrameless(this)');
popupCloseLabel.innerHTML = "<table width='100%'><tr><td><hr width='100%'></td></tr>"
+ "<tr><td><span class='sbc-text'><nobr>- Click image to close -</nobr></span></td></tr></table>";
popupCloseLabel.style.width = maxWidth + "px";
popupCloseLabel.className = "popupDivClosure";
popupDiv.appendChild(popupCloseLabel);

// Determine the size of the current window and decide whether to shift image start up or to the right to accomodate
var windowWidth =  findClientWidth();
var windowHeight =  findClientHeight();
var xStartPoint = (mouseX - (offsetPad * 3));
var yStartPoint =  (mouseY - (offsetPad * 3));
var scrollPosX = findScrollLeft();
var scrollPosY = findScrollTop();

// Don't let popup go below the bottom of visible screen
if(((mouseY + maxHeight + (offsetPad * 3)) - (window.getComputedStyle ? scrollPosY : 0)) > windowHeight)
	{
	popupDiv.style.top = ((windowHeight + scrollPosY) - (maxHeight + (offsetPad * 5))) + "px";
	}
else
	{
	popupDiv.style.top = (mouseY + (window.getComputedStyle ? 0: scrollPosY) - offsetPad) + "px";
	}

// Don't let popup go beyond the right hand boundary of visible screen
if(((mouseX + maxWidth + (offsetPad * 3)) - (window.getComputedStyle ? scrollPosX : 0)) > windowWidth)
	{
	popupDiv.style.left = ((windowWidth + scrollPosX) - (maxWidth + (offsetPad * 5))) + "px";
	}
else
	{
	popupDiv.style.left = (mouseX + (window.getComputedStyle ? 0: scrollPosX) - offsetPad) + "px"; //window.getComputedStyle
	}

//popupDiv.style.top = (((windowHeight - maxHeight) / 2) + scrollPosY) + "px";
//popupDiv.style.left = (((windowWidth - maxWidth) / 2) + scrollPosX) + "px";

// Set the new div to open in the right place and the right size
popupDiv.style.width = maxWidth  +  "px";
popupDiv.style.height =  maxHeight + (offsetPad * 3) + "px";

// Add the div to the body to display it
var body = document.getElementsByTagName("body");
body[0].appendChild(popupDiv);

currentPopup = popupImage;

expandPopUp(0, maxHeight)

document.body.style.cursor = 'default';
}


// ************************************************************************************************************************************************************
// Expands the popup image
// ************************************************************************************************************************************************************
function expandPopUp(currentHeight, maxHeight)
{

if((popupImage.style.height != null) && (popupImage.style.width != null))
	{
	if(currentHeight <= maxHeight)
		{
		popupDiv.style.height = (currentHeight + (offsetPad * 3)) + "px";
		popupImage.style.height = currentHeight + "px";
		currentHeight += (maxHeight * 0.1);
		var command = "expandPopUp(" + currentHeight + "," + maxHeight + ")";
		setTimeout(command,0);
		}
	else
		{
		popupDiv.style.height = (maxHeight + (offsetPad * 3)) + "px";
		popupImage.style.height = maxHeight + "px";
		}
	}
else
	{
	var command = "expandPopUp(" + currentHeight + "," + maxHeight + ")";
	setTimeout(command,0);
	}
}

// ************************************************************************************************************************************************************
// Close the image popup
// ************************************************************************************************************************************************************
function closePopFrameless(img) {
if(img && img.parentNode)
	{
	var body = document.getElementsByTagName("body");
	body[0].removeChild(currentPopup.parentNode);
	currentPopup = null;
	}
}

// ************************************************************************************************************************************************************
// Browser neutrality
// ************************************************************************************************************************************************************
function findClientWidth() {
	return f_filterResults (
		window.innerWidth ? window.innerWidth : 0,
		document.documentElement ? document.documentElement.clientWidth : 0,
		document.body ? document.body.clientWidth : 0
	);
}
function findClientHeight() {
	return f_filterResults (
		window.innerHeight ? window.innerHeight : 0,
		document.documentElement ? document.documentElement.clientHeight : 0,
		document.body ? document.body.clientHeight : 0
	);
}
function findScrollLeft() {
	return f_filterResults (
		window.pageXOffset ? window.pageXOffset : 0,
		document.documentElement ? document.documentElement.scrollLeft : 0,
		document.body ? document.body.scrollLeft : 0
	);
}
function findScrollTop() {

	return f_filterResults (
		window.pageYOffset ? window.pageYOffset : 0,
		document.documentElement ? document.documentElement.scrollTop : 0,
		document.body ? document.body.scrollTop : 0
	);
}
function f_filterResults(n_win, n_docel, n_body) {
	var n_result = n_win ? n_win : 0;
	if (n_docel && (!n_result || (n_result > n_docel)))
		n_result = n_docel;
	return n_body && (!n_result || (n_result > n_body)) ? n_body : n_result;
}

// ************************************************************************************************************************************************************
// Record where the mouse is when it is clicked on an enlargeable image or when mose is moved while a SKU popup is open.
// ************************************************************************************************************************************************************
function locateMouse(e)
{
if (!e) var e = window.event;
if (e.pageX || e.pageY)
	{
	mouseX  = e.pageX;
	mouseY = e.pageY;
	}
else if (e.clientX || e.clientY)
	{
	mouseX  = e.clientX;
	mouseY = e.clientY;
	}

//var displayPos = document.getElementById("searchBox");
//if(displayPos != null) displayPos.value = mouseX  + ":" + mouseY + " " + allowHoverPopupClose + ":" + mouseHasExited + ":" +  mouseFirstEntry;

if((hoverPopupDiv != null) && (checkForRemoval == null))
	{
	checkForRemoval = 1;
	var scrollPosX = findScrollLeft();
	var scrollPosY = findScrollTop();

	var xOffset = (window.getComputedStyle ? 0: scrollPosX);
	var yOffset = (window.getComputedStyle ? 0: scrollPosY);

	if((mouseHasExited == true)
		&& (mouseX >= (floatLeftOffset)) 
		&& (mouseX <= (floatLeftOffset  + hoverPopupDiv.offsetWidth)) 
		&& (mouseY >= (launchMouseY + verticalOffset)) 
		&& ((mouseY <= (launchMouseY + hoverPopupDiv.offsetHeight))))
		{
			mouseHasExited = false;
			mouseFirstEntry = true;
			endHoverTimeout();
			listDeactivated();
		}

	if ((mouseX < floatLeftOffset) 
		|| (mouseX > (floatLeftOffset  + hoverPopupDiv.offsetWidth)) 
		|| (mouseY < (launchMouseY + verticalOffset)) 
		|| (mouseY > (launchMouseY + hoverPopupDiv.offsetHeight + verticalOffset)))
		{
			mouseHasExited = true;
		}

	if((allowHoverPopupClose == true)  &&  (mouseFirstEntry == true)
		&& ((mouseX < (floatLeftOffset  - removalPad)) 
			|| (mouseX > (floatLeftOffset  + hoverPopupDiv.offsetWidth + removalPad)) 
			|| (mouseY < (launchMouseY - removalPad + verticalOffset)) 
			|| ((mouseY > (launchMouseY + hoverPopupDiv.offsetHeight + removalPad + verticalOffset)))))
		{
		if(mouseHasExited == true)
			{
			checkForRemoval = null;
			startHoverTimeout(navHoverDelayExit);
			}
		}

	checkForRemoval = null;
	}
}

// ************************************************************************************************************************************************************
function preview(URL, id)
{
	eval("page" + id + " = window.open(URL, '" + id + "', 'toolbar=1,scrollbars=1,location=1,statusbar=1,menubar=1,resizable=1');");
}


// ************************************************************************************************************************************************************
// Makes prior non-image page popups work - must remap popUp() to popUpPrior()
// ************************************************************************************************************************************************************
function popUpPrior(URL) {
day = new Date();
id = day.getTime();
eval("page" + id + " = window.open(URL, '" + id + "', 'toolbar=0,scrollbars=1,location=0,statusbar=0,menubar=0,resizable=1,width=450,height=500,left = 125,top = 100');");
}


// ************************************************************************************************************************************************************
function popUpShip(URL) {
day = new Date();
id = day.getTime();
eval("page" + id + " = window.open(URL, '" + id + "', 'toolbar=0,scrollbars=1,location=0,statusbar=0,menubar=0,resizable=1,width=475,height=435,left = 250,top = 100');");
}

// ************************************************************************************************************************************************************
function submitForm(form, context, app, abcFormName, method, isConfirm) 
{
    url = context + "/do/" + app + "/";
    //alert('url= ' + url);
    if (isConfirm==true)
    {
    	var isDelete=confirm('Delete it?');
     	if (isDelete==true)
	    {
	    	//alert('confirmed ' + isDelete);
		    form.action=url + abcFormName + '?method=' + method;
		    //alert(url + abcFormName + '?method=' + method);
		    form.submit();
		    return true;
	    }
	    else
	    {
	        return false;
	    	//alert('cancelled');
	    }
 	}
 	else
 	{
		//alert('just submit it');
		form.action=url + abcFormName + '?method=' + method;
		form.submit();
		return true;
	}
}


// ************************************************************************************************************************************************************
function ShowFamily()
{
	if (navigator.appName!="Microsoft Internet Explorer")
	{
	   var items = document.getElementsByName("item");
	   for (var i = 0; i < items.length; i++)
	   {
	     items[i].style.display = "none";
  	   }
	}
	else
	{
	    //ie kludge
	    trs = document.getElementsByTagName("TR");
	    {
	       for (i=0; i < trs.length; i++)
	       {
	           if (trs[i].name == "item") trs[i].style.display = "none";
	       }
	    }
	    trs = document.getElementsByTagName("table");
	    {
	       for (i=0; i < trs.length; i++)
	       {
	           if (trs[i].name == "item") trs[i].style.display = "none";
	       }
	    }
	    trs = document.getElementsByTagName("a");
	    {
	       for (i=0; i < trs.length; i++)
	       {
	           if (trs[i].name == "item") trs[i].style.display = "none";
	       }
	    }
	}
}

// for "family" category pages to automatically hide part of the page
// ************************************************************************************************************************************************************
function DoExpand(familyName, itemName, numberOfItems) 
{
    ShowHideElements(familyName, itemName, numberOfItems, false)  
}

// ************************************************************************************************************************************************************
function DoContract(familyName, itemName, numberOfItems) 
{
	ShowHideElements(familyName, itemName, numberOfItems, true)
}

// ************************************************************************************************************************************************************
function ShowHideElements(familyName, itemName, numberOfItems, isShow)
{
    var itemDisplay;
    var familyDisplay;
	if (isShow)
	{
		itemDisplay="none";
		familyDisplay="";
	}
	else
	{
		itemDisplay="";
		familyDisplay="none";
	}
	
	var id0=itemName + "_0";
	var id4 = itemName + "_" + (1+1*numberOfItems);
	var element= document.getElementById(id0);
	element.style.display = familyDisplay; 
  	
   	for (var i = 0; i < numberOfItems; i++)
   	{
   		var id1 = itemName + "_" + (i+1);
   		var element = document.getElementById(id1);
   		element.style.display = itemDisplay;
  	}
    if (numberOfItems > 0)
  	{
  		document.getElementById(id4).style.display = itemDisplay; 
  	}
  
    if (navigator.appName!="Microsoft Internet Explorer")
    {
        var family = document.getElementsByName(familyName);
	    for (var i = 0; i < family.length; i++)
	    {
			family[i].style.display = familyDisplay;
	    }
     }
     else
     {
	     //ie kludge
	     spans = document.getElementsByTagName("a");
 	     for (i=0; i < spans.length; i++)
 	     {
 		    if (spans[i].name == familyName) spans[i].style.display = familyDisplay;
 	     }
	 }
}


//************************ START Drop Down Menu-  Dynamic Drive ***************************************************************
/***********************************************
* AnyLink Drop Down Menu-  Dynamic Drive (www.dynamicdrive.com)
* This notice MUST stay intact for legal use
* Visit http://www.dynamicdrive.com/ for full source code
***********************************************/

var menuwidth='165px' //default menu width
var menubgcolor='lightyellow'  //menu bgcolor
var disappeardelay=250  //menu disappear speed onMouseout (in miliseconds)
var hidemenu_onclick="yes" //hide menu when user clicks within menu?

/////No further editting needed

var ie4=document.all
var ns6=document.getElementById&&!document.all

if (ie4||ns6)
document.write('<div id="dropmenudiv" style="visibility:hidden;width:'+menuwidth+';background-color:'+menubgcolor+'" onMouseover="clearhidemenu()" onMouseout="dynamichide(event)"></div>')

function getposOffset(what, offsettype)
{
	var totaloffset=(offsettype=="left")? what.offsetLeft : what.offsetTop;
	var parentEl=what.offsetParent;
	while (parentEl!=null){
	totaloffset=(offsettype=="left")? totaloffset+parentEl.offsetLeft : totaloffset+parentEl.offsetTop;
	parentEl=parentEl.offsetParent;
	}
	return totaloffset;
}


function showhide(obj, e, visible, hidden, menuwidth)
{
	if (ie4||ns6)
		dropmenuobj.style.left=dropmenuobj.style.top="-500px"
	if (menuwidth!="")
	{
		dropmenuobj.widthobj=dropmenuobj.style
		dropmenuobj.widthobj.width=menuwidth
	}
	if (e.type=="click" && obj.visibility==hidden || e.type=="mouseover")
	obj.visibility=visible
	else if (e.type=="click")
	obj.visibility=hidden
}

function iecompattest()
{
	return (document.compatMode && document.compatMode!="BackCompat")? document.documentElement : document.body
}

function clearbrowseredge(obj, whichedge)
{
	var edgeoffset=0
	if (whichedge=="rightedge")
	{
		var windowedge=ie4 && !window.opera? iecompattest().scrollLeft+iecompattest().clientWidth-15 : window.pageXOffset+window.innerWidth-15
		dropmenuobj.contentmeasure=dropmenuobj.offsetWidth
		if (windowedge-dropmenuobj.x < dropmenuobj.contentmeasure)
			edgeoffset=dropmenuobj.contentmeasure-obj.offsetWidth
	}
	else
	{
		var topedge=ie4 && !window.opera? iecompattest().scrollTop : window.pageYOffset
		var windowedge=ie4 && !window.opera? iecompattest().scrollTop+iecompattest().clientHeight-15 : window.pageYOffset+window.innerHeight-18
		dropmenuobj.contentmeasure=dropmenuobj.offsetHeight
		if (windowedge-dropmenuobj.y < dropmenuobj.contentmeasure)
		{ //move up?
			edgeoffset=dropmenuobj.contentmeasure+obj.offsetHeight
			if ((dropmenuobj.y-topedge)<dropmenuobj.contentmeasure) //up no good either?
				edgeoffset=dropmenuobj.y+obj.offsetHeight-topedge
		}
	}
	return edgeoffset
}

function populatemenu(what)
{
	if (ie4||ns6)
		dropmenuobj.innerHTML=what.join("")
}


function dropdownmenu(obj, e, menucontents, menuwidth)
{
	removeHoverPopup();
	if (window.event) event.cancelBubble=true
	else if (e.stopPropagation) e.stopPropagation()

	clearhidemenu()
	dropmenuobj=document.getElementById? document.getElementById("dropmenudiv") : dropmenudiv
	populatemenu(menucontents)

	if (ie4||ns6)
	{
		showhide(dropmenuobj.style, e, "visible", "hidden", menuwidth)
		dropmenuobj.x=getposOffset(obj, "left")
		dropmenuobj.y=getposOffset(obj, "top")
		dropmenuobj.style.left=dropmenuobj.x-clearbrowseredge(obj, "rightedge")+"px"
		dropmenuobj.style.top=dropmenuobj.y-clearbrowseredge(obj, "bottomedge")+obj.offsetHeight+"px"
	}

	return clickreturnvalue()
}

function clickreturnvalue()
{
	if (ie4||ns6) return false
		else return true
}

function contains_ns6(a, b) 
{
	while (b.parentNode)
	if ((b = b.parentNode) == a)
		return true;
	return false;
}

function dynamichide(e)
{
	if (ie4&&!dropmenuobj.contains(e.toElement))
		delayhidemenu()
	else if (ns6&&e.currentTarget!= e.relatedTarget&& !contains_ns6(e.currentTarget, e.relatedTarget))
		delayhidemenu()
}

function hidemenu(e)
{
	if (typeof dropmenuobj!="undefined")
	{
		if (ie4||ns6)
			dropmenuobj.style.visibility="hidden"
	}
}

function delayhidemenu()
{
	if (ie4||ns6)
		delayhide=setTimeout("hidemenu()",disappeardelay)
}

function clearhidemenu()
{
	if (typeof delayhide!="undefined")
		clearTimeout(delayhide)
}

if (hidemenu_onclick=="yes")
	document.onclick=hidemenu
//************************ END Drop Down Menu-  Dynamic Drive ***************************************************************
// ************************************COPYRIGHT BostonGreenGoods.com - All rights reserved. ****************************************************