// ABC_asssit_helpers.js - v1.2 released 11/10/2005 by Ira Baron
// Checkout and Product Assistance functions 
// REQUIRES: ABC_popup_helpers.js; abc_helper_consts.js
// AllergyBuyersClub.com - all rights reserved

// ===============================================
// Functions to manage the presentation of images/buttons related to providing
// assistance to customers (e.g., phone and online chat)
// ===============================================

// Tests whether the ABC offices are open and, therefore, salespeople are avaialable
function abc_openForBusiness()
	{
	// What date and time at the customer's browser?
	var custDate = new Date();
	var custDay = custDate.getDay();
	var custHour = custDate.getHours();
	
	// How far are they from GMT?
	var custTZOffset = custDate.getTimezoneOffset() / 60; //Hours between cust and GMT time
	
	// What time is it in Waltham MA (and what day)??
	var abcHour = (custHour -  custTZOffset) + GMT_OFFSET; // Waltham is 5 hours behind GMT
	var abcDay = custDay;

	// What days and hours are phone sales folks available?
	// Is the store open?
	if(((abcHour >= STORE_OPEN) && (abcHour <= STORE_CLOSE)) 
			&& ((abcDay >= WEEK_START) && (abcDay <= WEEK_END)))
		{
		return true;
		}
	else
		{
		return false;
		}
	}

// ==== Chat assist image display management =================
// Place the chat assistance image as far right as possible - may be offset by phone image
function abc_positionChatAssistImage(displayElement, pageType)
	{
	var xPos = "0px";
	var yPos = "0px";
	
	// What kind of page will dictate location
	if(pageType == "MIVA")
		{
		yPos = MIVA_ASSIST_YPOS;
		if(abc_openForBusiness())  // If the store is open, make room for phone image
			{
			xPos = MIVA_ASSIST_XPOS_DOUBLE;
			}
		else
			{
			xPos = MIVA_ASSIST_XPOS_SINGLE;
			}
		}
	
  	if (dom && !document.all) 
		{
		var elem = document.getElementById(displayElement);
		if(elem)
			{
			elem.style.top = yPos;
			elem.style.left = xPos;
			}
		}

  	if (document.layers) 
		{
		var elem = document.layers[displayElement];
		if(elem)
			{
			elem.top = yPos;
			elem.left = xPos;
			}
		}

  	if (document.all) 
		{
		var elem = document.all[displayElement];
		if(elem)
			{
			elem.style.top = yPos;
			elem.style.left = xPos;
			}
		}
	}

// Display the chat assist image
function abc_showChatAssistImage(displayElement)
	{
   	if (dom && !document.all) 
		{
		var elem = document.getElementById(displayElement);
		if(elem)
			{
			elem.style.visibility='visible';
			}
		}

  	if (document.layers) 
		{
		var elem = document.layers[displayElement];
		if(elem)
			{
			elem.visibility='show';
			}
		}

  	if (document.all) 
		{
		var elem = document.all[displayElement];
		if(elem)
			{
			elem.style.visibility='visible';
			}
		}
	}

// Hide the chat assist image
function abc_hideChatAssistImage(displayElement)
	{
  	if (dom && !document.all) 
		{
		var elem = document.getElementById(displayElement);
		if(elem)
			{
			elem.style.visibility='hidden';
			}
		}

  	if (document.layers) 
		{
		var elem = document.layers[displayElement];
		if(elem)
			{
			elem.visibility='hide';
			}
		}

  	if (document.all) 
		{
		var elem = document.all[displayElement];
		if(elem)
			{
			elem.style.visibility='hidden';
			}
		}
	}

// ======= Phone assist image display management =================
// Position the phone assist image
function abc_positionPhoneAssistImage(displayElement, pageType)
	{
	var xPos = "0px";
	var yPos = "0px";
	
	// What kind of page will dictate location
	if(pageType == "MIVA")
		{
		yPos = MIVA_ASSIST_YPOS;
		xPos = MIVA_ASSIST_XPOS_SINGLE;
		}
	
 	if (dom && !document.all) 
		{
		var elem = document.getElementById(displayElement);
		if(elem)
			{
			elem.style.top = yPos;
			elem.style.left = xPos;
			}
		}

 	if (document.layers) 
		{
		var elem = document.layers[displayElement];
		if(elem)
			{
			elem.top = yPos;
			elem.left = xPos;
			}
		}
			
  	if (document.all) 
		{
		var elem = document.all[displayElement];
		if(elem)
			{
			elem.style.top = yPos;
			elem.style.left = xPos;
			}
		}
	}

// Display the phone assist image
function abc_showPhoneAssistImage(displayElement)
	{
	if(abc_openForBusiness())
		{
 	  	if (dom && !document.all) 
			{
			var elem = document.getElementById(displayElement);
			if(elem)
				{
				elem.style.visibility='visible';
				}
			}
	
	 	if (document.layers) 
			{
			var elem = document.layers[displayElement];
			if(elem)
				{
				elem.visibility='show';
				}
			}
			
	  	if (document.all) 
			{
			var elem = document.all[displayElement];
			if(elem)
				{
				elem.style.visibility='visible';
				}
			}
		}
	}

// Hide the phone assist image
function abc_hidePhoneAssistImage(displayElement)
	{
  	if (dom && !document.all) 
		{
		var elem = document.getElementById(displayElement);
		if(elem)
			{
			elem.style.visibility='hidden';
			}
		}
	
 	if (document.layers) 
		{
		var elem = document.layers[displayElement];
		if(elem)
			{
			elem.visibility='hide';
			}
		}
			
  	if (document.all) 
		{
		var elem = document.all[displayElement];
		if(elem)
			{
			elem.style.visibility='hidden';
			}
		}
	}

// If the store is open, show the phone assist in the right place
function abc_showPhoneIfOpen(displayElement, pageType)
	{
	if(abc_openForBusiness())
		{
		abc_positionPhoneAssistImage(displayElement, pageType);
		abc_showPhoneAssistImage(displayElement);
		}
	else
		{
		abc_hidePhoneAssistImage(displayElement);		
		}
	}

// ========= Assistance offer management

// If all agents have become unavialable, hide the assist popup
function abc_closeIfNoProficientHelpAvailable()
	{
	var isOnDuty = false;
	
	if (dom && !document.all) 
		{
		var elem = document.getElementById('psys_rm_control_on');
		if(elem)
			{
			if(elem.style.visibility == 'visible')
				{
				isOnDuty = true;
				}
			}
		}
	
 	if (document.layers) 
		{
		var elem = document.layers['psys_rm_control_on'];
		if(elem)
			{
			if(elem.visibility == 'show')
				{
				isOnDuty = true;
				}
			}
		}
			
  	if (document.all) 
		{
		var elem = document.all['psys_rm_control_on'];
		if(elem)
			{
			if(elem.style.visibility == 'visible')
				{
				isOnDuty = true;
				}
			}
		}
	
	if(!isOnDuty)      
		{
		abc_hidePopup() ;
		}
	else
		{
		if(showingPopupIsShowing)
			{
			setTimeout("abc_closeIfNoProficientHelpAvailable()", PROF_POPUP_AGENT_HIDE_POLL_TIME);
			}
		}
	}

// ========= Checkout chat assistance offer management

// Used by shopping cart pages to set the time delay before offering chat assistance
var timeoutCkOutObject = null;

// If the user is active in the page, reset timeout
function abc_getKeyStrokeForCkOutAssistReset()
	{
	abc_resetCkOutAssistTimeout();
	}

var pageTimeout = 120000; // Two minutes by default - can be set in onLoad at body level.

// When opening a page or based on user keystrokes, reset the timeout
function abc_resetCkOutAssistTimeout(timeout)
	{
	if(timeout != null) 
		{
		pageTimeout = timeout;
		}
	
	if(timeoutCkOutObject != null)
		{
		window.clearTimeout(timeoutCkOutObject);
		}
	timeoutCkOutObject = setTimeout("abc_ringCkOutAgent()", pageTimeout); 
	}

function abc_agentIsOnDuty()
	{
	var isOnDuty = false;
	
	if (dom && !document.all) 
		{
		var elem = document.getElementById('psys_rm_control_on');
		if(elem)
			{
			if(elem.style.visibility == 'visible')
				{
				isOnDuty = true;
				}
			}
		}
	
 	if (document.layers) 
		{
		var elem = document.layers['psys_rm_control_on'];
		if(elem)
			{
			if(elem.visibility == 'show')
				{
				isOnDuty = true;
				}
			}
		}
			
  	if (document.all) 
		{
		var elem = document.all['psys_rm_control_on'];
		if(elem)
			{
			if(elem.style.visibility == 'visible')
				{
				isOnDuty = true;
				}
			}
		}
	return isOnDuty;
	}

// If we have not alread offered and if an agent is available, bring up the invitation to chat
function abc_ringCkOutAgent() 
	{
	if(abc_agentIsOnDuty())      
		{
		if((null == abc_readABCCookie("ABCReactiveCkOutChat")) 
				&& (abc_testABCCookiesAreOn())) // Check to ensure cookies are enabled and we haven't already invited
			{
			abc_createABCCookie("ABCReactiveCkOutChat", "true", CHAT_COOKIE_TIMEOUT);  // Set the cookie so we don't launch again.
			abc_showPopup('checkoutAssist', PROF_ASSIST_POPUP_WIDTH, PROF_ASSIST_POPUP_HEIGHT);
			setTimeout("abc_closeIfNoProficientHelpAvailable('checkoutAssist')", PROF_POPUP_AGENT_HIDE_POLL_TIME)
			}
		}
	else
		{
		abc_resetCkOutAssistTimeout(PROF_POPUP_AGENT_SHOW_POLL_TIME);
		}
	}

// ========= Product chat assistance offer management
// Used by product pages to set the time delay before offering chat assistance
var timeoutProductObject = null;

// If the user is active in the page, reset timeout
function abc_getKeyStrokeForProductAssistReset()
	{
	abc_resetProductAssistTimeout();
	}

// When opening a page or based on user keystrokes, reset the timeout
function abc_resetProductAssistTimeout(timeout)
	{
	if(timeout != null) 
		{
		pageTimeout = timeout;
		}
	
	if(timeoutProductObject != null)
		{
		window.clearTimeout(timeoutProductObject);
		}
	timeoutProductObject = setTimeout("abc_ringProductAgent()", pageTimeout); 
	}

//If we have not alread offered and if an agent is available, bring up the invitation to chat
function abc_ringProductAgent() 
	{
	var isOnDuty = false;
	
	if (dom && !document.all) 
		{
		var elem = document.getElementById('psys_rm_control_on');
		if(elem)
			{
			if(elem.style.visibility == 'visible')
				{
				isOnDuty = true;
				}
			}
		}
	
 	if (document.layers) 
		{
		var elem = document.layers['psys_rm_control_on'];
		if(elem)
			{
			if(elem.visibility == 'show')
				{
				isOnDuty = true;
				}
			}
		}
			
  	if (document.all) 
		{
		var elem = document.all['psys_rm_control_on'];
		if(elem)
			{
			if(elem.style.visibility == 'visible')
				{
				isOnDuty = true;
				}
			}
		}
	
	if(isOnDuty)      
		{
		if((null == abc_readABCCookie("ABCReactiveProductChat")) 
				&& (abc_testABCCookiesAreOn())) // Check to ensure cookies are enabled and we haven't already invited
			{
			abc_createABCCookie("ABCReactiveProductChat", "true", CHAT_COOKIE_TIMEOUT);  // Set the cookie so we don't launch again.
			abc_showPopup('productAssist', PROF_ASSIST_POPUP_WIDTH, PROF_ASSIST_POPUP_HEIGHT);
			setTimeout("abc_closeIfNoProficientHelpAvailable('productAssist')", PROF_POPUP_AGENT_HIDE_POLL_TIME)
			}
		}
	else
		{
		abc_resetProductAssistTimeout(PROF_POPUP_AGENT_SHOW_POLL_TIME);
		}
	}
