// ABC_popup_helpers. js - v1.2.1 released 11/10/2005 by Ira Baron
// Invoke popups to assist customers.
// AllergyBuyersClub.com - all rights reserved

// ===============================================
// Functions to manage the presentation of popup images/dialogs posed as HTML layers
// ===============================================

// Check whether there is a DOM to leverage
(document.getElementById) ? dom = true : dom = false;

// Preserve information about the popup currently displayed
var showingPopupName = "";
var showingPopupHeight = 0;
var showingPopupWidth = 0;
var showingPopupIsShowing = false;

// Establish the popup to show
function abc_setPopup(popupName, popH, popW)
	{
	showingPopupName = popupName;
	showingPopupHeight = popH;
	showingPopupWidth = popW;
	}

// Show the popup in the right location
function abc_showPopup(popupName, popH, popW) 
	{
	// Set the current popup data
	abc_setPopup(popupName, popH, popW);
	
	// Place the popup location dynamically
	abc_placePopup();  

  	if (dom) 
		{
		var elem = document.getElementById(showingPopupName);
		if(elem)
			{
			elem.style.visibility='visible';
			}
		}

 	if (document.layers) 
		{
		var elem = document.layers[showingPopupName];
		if(elem)
			{
			elem.visibility='show';
			}
		}
	showingPopupIsShowing = true;
	}

// Hide the popup
function abc_hidePopup(popupName) 
	{
	// If no popupName provided, kill the most recently popped
	var killPopup = (popupName != null) ? popupName : showingPopupName;

  	if (dom) 
		{
		var elem = document.getElementById(killPopup);
		if(elem)
			{
			elem.style.visibility='hidden';
			}
		}

 	if (document.layers) 
		{
		var elem = document.layers[killPopup];
		if(elem)
			{
			elem.visibility='hide';
			}
		} 
	showingPopupIsShowing = false;
	}

// Locate the popup in the right place
function abc_placePopup() 
	{
	var winW = 800, winH = 480;				// Default
   	var scrollPos = 0;						// Default
	var popW = showingPopupWidth, popH = showingPopupHeight;	// Popup dimensions

	// Find scroll offset.  May need to reset in following, find-center code
	if (document.body) 
		{
		scrollPos = document.documentElement.scrollTop;
		}
	if(self.pageYOffset)
		{
		scrollPos = window.pageYOffset;
		}

	// Find the center of the window - default to screen dimensions
	winW = screen.width;
	winH = screen.height;

  	if (document.all) 
		{
		winW = document.body.clientWidth;
//		winH = document.body.clientHeight;
//		winW = window.screen.availWidth;
		winH = window.screen.availHeight * .8;  // To ensure that the popup is pretty well always visible.
//		winH = window.screen.height;  // To ensure that the popup is pretty well always visible.
		}

  	if ((document.layers) || (dom && !document.all))
		{
		winW = window.innerWidth;
		winH = window.innerHeight;
		}

	// Default to upper left corner if the preceding failed
	var xPos = 1, yPos = 1;		
	xPos = parseInt((winW / 2.3) - (popW / 2)); // Shift left, slightly
	yPos = parseInt((winH / 2) - (popH / 2));

  	if (dom && !document.all) 
		{
		var elem = document.getElementById(showingPopupName);
		if(elem)
			{
			elem.style.top = parseInt(yPos + scrollPos) + "px";
			elem.style.left = xPos;
			elem.style.zIndex = 1;			
			}
		}

  	if (document.layers) 
		{
		var elem = document.layers[showingPopupName];
		if(elem)
			{
			elem.top = parseInt(yPos + scrollPos);
			elem.left = xPos;
			elem.zIndex = 1;
			}
		}

  	if (document.all) 
		{
		var elem = document.all[showingPopupName];
		if(elem)
			{
			elem.style.top = parseInt(yPos + scrollPos);
			elem.style.left = xPos;
			elem.style.zIndex = 1;
			}
		}

 	window.setTimeout("abc_placePopup()", POPUP_SCROLL_FOLLOW_TIME); 
	}
